//+------------------------------------------------------------------+
//|                                                       SMA CT.mq4 |
//|                                                     Torsten Ryll |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Torsten Ryll"
#property link      ""

extern double Lots = 1;
extern double SLLong = 40;
extern double TPLong = 40;
extern double SLShort= 40;
extern double TPShort= 40;
extern double StartLong=5;
extern double StartShort=5;


//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
int start()
  {
  double SMA20aktuell;
  double SMA20_40;
  int total;
  double ticket;
  bool testtrend;
//----
   SMA20aktuell=iMA(NULL,0,20,0,1,0,0);
   SMA20_40=iMA(NULL,0,20,0,1,0,40);
   
   total=OrdersTotal();
   if(total<1) 
     {
      // no opened orders identified
      if(AccountFreeMargin()<(1000*Lots))
        {
         Print("We have no money. Free Margin = ", AccountFreeMargin());
         return(0);  
        }
      // check for long position (BUY) possibility
      if (SMA20aktuell<SMA20_40 && Close[0]<Open[0] && High[0]>SMA20aktuell)  
         {
         testtrend=True;
         for(int i=40; i>0; i--)
            {
            if  (iMA(NULL,0,20,0,1,0,i-1)>iMA(NULL,0,20,0,1,0,i)) testtrend=false;
            }
         if (testtrend) ticket=OrderSend(Symbol(),OP_BUYSTOP,Lots,High[0]+StartLong*Point,0,High[0]+(StartLong-SLLong)*Point,High[0]+(StartLong+TPLong)*Point,"sample",16384,0,Green);
         }
      // check for short position (SELL) possibility
      if (SMA20aktuell>SMA20_40 && Close[0]>Open[0] && Low[0]<SMA20aktuell)  
         {
         testtrend=True;
         for(i=40; i>0; i--)
            {
            if  (iMA(NULL,0,20,0,1,0,i-1)<iMA(NULL,0,20,0,1,0,i)) testtrend=false;
            }
         if (testtrend) ticket=OrderSend(Symbol(),OP_SELLSTOP,Lots,Low[0]-StartShort*Point,0,Low[0]+(-StartShort+SLShort)*Point,Low[0]+(-StartShort-TPShort)*Point,"sample",16384,0,Red);
         }
     }
//----
   return(0);
  }
//+------------------------------------------------------------------+